/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.util;

import a2u.tn.utils.json.MapNavigator;
import a2u.tn.utils.json.TnJson;
import a2u.tn.utils.json.TnJsonBuilder;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.wd.yamlhelper.util.JsonAssistantUtil;
import com.wd.yamlhelper.util.JsonUtil;
import com.wd.yamlhelper.wapper.ArrayWrapper;
import com.wd.yamlhelper.wapper.JsonWrapper;
import com.wd.yamlhelper.wapper.ObjectWrapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;

public class Json5Util {
    public static final TnJsonBuilder FORMAT_JSON5 = TnJson.builder().readable().formated().withoutKeyQuote().singleQuote().keepNull();
    public static final TnJsonBuilder COMPACT_JSON5 = TnJson.builder().readable().withoutKeyQuote().singleQuote().keepNull();

    public static boolean isJson5(String text) {
        Object data = Json5Util.tryResolveJson5(text);
        return data instanceof Map || data instanceof List;
    }

    public static boolean isJson5Array(String text) {
        return Json5Util.tryResolveJson5(text) instanceof List;
    }

    public static boolean isJson5Object(String text) {
        return Json5Util.tryResolveJson5(text) instanceof Map;
    }

    public static String formatJson5(String json) {
        return Json5Util.toJson5Str(Json5Util.tryResolveJson5(json), FORMAT_JSON5);
    }

    public static String compressJson5(String json) {
        return Json5Util.toJson5Str(Json5Util.tryResolveJson5(json), COMPACT_JSON5);
    }

    public static String compressJson5(Object data) {
        return Json5Util.toJson5Str(data, COMPACT_JSON5);
    }

    public static JsonWrapper parse(String json) {
        if (Json5Util.isJson5Object(json)) {
            return Json5Util.parseObject(json);
        }
        if (Json5Util.isJson5Array(json)) {
            return Json5Util.parseArray(json);
        }
        return null;
    }

    public static ObjectWrapper parseObject(String text) {
        return new ObjectWrapper(Json5Util.resolveJson5(text));
    }

    public static ArrayWrapper parseArray(String text) {
        return new ArrayWrapper(Json5Util.resolveJson5(text));
    }

    public static String convertJson5ToJson(String json5Str) {
        Object data = Json5Util.resolveJson5(json5Str);
        return Objects.isNull(data) ? null : JsonUtil.formatJson(data);
    }

    public static String convertJsonToJson5(String jsonStr) {
        return Json5Util.toJson5Str(JsonUtil.parse(jsonStr));
    }

    public static String toJson5Str(Object obj) {
        return Json5Util.toJson5Str(obj, FORMAT_JSON5);
    }

    public static String toJson5Str(Object data, TnJsonBuilder builder) {
        try {
            String json5 = builder.buildJson(data);
            return JsonAssistantUtil.unicodeToString(json5);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object tryResolveJson5(String text) {
        return JsonUtil.isJson(text) ? null : Json5Util.resolveJson5(text);
    }

    public static Object resolveJson5(String text) {
        if (StrUtil.isBlank((CharSequence)text)) {
            return null;
        }
        Map map = null;
        try {
            map = TnJson.parse((String)text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (MapUtil.isEmpty((Map)map)) {
                text = StringEscapeUtils.unescapeJson((String)text);
                map = TnJson.parse((String)text);
            }
            if (MapUtil.isNotEmpty((Map)map)) {
                Object list;
                if (map.size() == 1 && (list = MapNavigator.fromPath((Map)map, (String)"list")) instanceof List) {
                    return list;
                }
                return map;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

