/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.wapper;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.wd.yamlhelper.action.CollapseAllAction;
import com.wd.yamlhelper.action.CollapseMultiAction;
import com.wd.yamlhelper.action.CopyKeyAction;
import com.wd.yamlhelper.action.CopyKeyValueAction;
import com.wd.yamlhelper.action.CopyNodePathAction;
import com.wd.yamlhelper.action.CopyValueAction;
import com.wd.yamlhelper.action.ExpandAllAction;
import com.wd.yamlhelper.action.ExpandMultiAction;
import com.wd.yamlhelper.i18.YamlHelperBoundle;
import com.wd.yamlhelper.icon.PluginIcons;
import com.wd.yamlhelper.jump.JumpAction;
import com.wd.yamlhelper.listener.TreeRightClickPopupMenuMouseAdapter;
import com.wd.yamlhelper.node.JsonTreeNode;
import com.wd.yamlhelper.node.JsonTreeNodeType;
import com.wd.yamlhelper.parser.ConfigEntry;
import com.wd.yamlhelper.parser.YamlParser;
import com.wd.yamlhelper.persistent.YamlPersistent;
import com.wd.yamlhelper.util.JsonUtil;
import com.wd.yamlhelper.util.UIManagers;
import com.wd.yamlhelper.util.YamlUtil;
import com.wd.yamlhelper.wapper.ArrayWrapper;
import com.wd.yamlhelper.wapper.JsonWrapper;
import com.wd.yamlhelper.wapper.ObjectWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonStructureComponentProvider {
    private Tree tree;
    private JPanel treeComponent;

    public JsonStructureComponentProvider(JsonWrapper wrapper, @Nullable JComponent component, boolean needBorder, VirtualFile file) {
        this.init(wrapper, component, needBorder, file);
    }

    private void init(JsonWrapper wrapper, @Nullable JComponent component, boolean needBorder, VirtualFile file) {
        JsonTreeNode rootNode = new JsonTreeNode("root");
        if (wrapper != null) {
            this.convertToTreeNode(wrapper, rootNode);
        }
        this.tree = new Tree((TreeModel)new DefaultTreeModel(rootNode));
        this.tree.setDragEnabled(true);
        this.tree.setExpandableItemsEnabled(true);
        this.tree.setScrollsOnExpand(true);
        StyleTreeCellRenderer styleTreeCellRenderer = new StyleTreeCellRenderer();
        styleTreeCellRenderer.setFile(file);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)styleTreeCellRenderer));
        this.tree.addMouseListener((MouseListener)new TreeRightClickPopupMenuMouseAdapter(this.tree, this.buildRightMousePopupMenu()));
        new TreeSpeedSearch((JTree)this.tree);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.tree).addExtraAction((AnActionButton)new ExpandAllAction(this.tree, component, true)).addExtraAction((AnActionButton)new CollapseAllAction(this.tree, component, true));
        this.treeComponent = new JPanel(new BorderLayout());
        this.treeComponent.add((Component)decorator.createPanel(), "Center");
    }

    public void rebuildTree(JsonWrapper wrapper) {
        JsonTreeNode rootNode = new JsonTreeNode("root");
        if (wrapper != null) {
            this.convertToTreeNode(wrapper, rootNode);
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.setRoot(rootNode);
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        UIManagers.expandAll(this.tree, new TreePath(root));
    }

    private void convertToTreeNode(JsonWrapper jsonWrapper, JsonTreeNode node) {
        if (jsonWrapper instanceof ObjectWrapper) {
            ObjectWrapper jsonObject = (ObjectWrapper)jsonWrapper;
            if (Objects.isNull((Object)node.getNodeType())) {
                node.setNodeType(JsonTreeNodeType.JSONObject);
            }
            if (Objects.isNull(node.getValue())) {
                node.setValue(jsonObject);
            }
            node.setSize(jsonObject.size());
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                JsonTreeNode childNode = new JsonTreeNode(key);
                if (value instanceof ObjectWrapper) {
                    ObjectWrapper nestedJsonObject = (ObjectWrapper)value;
                    childNode.setValue(value).setNodeType(JsonTreeNodeType.JSONObject).setSize(nestedJsonObject.size());
                    this.convertToTreeNode(nestedJsonObject, childNode);
                } else if (value instanceof ArrayWrapper) {
                    ArrayWrapper jsonArray = (ArrayWrapper)value;
                    childNode.setValue(value).setNodeType(JsonTreeNodeType.JSONArray).setSize(jsonArray.size());
                    this.handleJsonArray(childNode, jsonArray);
                } else {
                    childNode.setValue(value).setNodeType(JsonTreeNodeType.JSONObjectProperty).setUserObject(key);
                }
                node.add(childNode);
            }
        } else if (jsonWrapper instanceof ArrayWrapper) {
            ArrayWrapper jsonArray = (ArrayWrapper)jsonWrapper;
            node.setNodeType(JsonTreeNodeType.JSONArray).setSize(jsonArray.size());
            if (Objects.isNull(node.getValue())) {
                node.setValue(jsonArray);
            }
            this.handleJsonArray(node, jsonArray);
        }
    }

    private void handleJsonArray(JsonTreeNode childNode, ArrayWrapper jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonTreeNode childNodeElement;
            Object el = jsonArray.get(i);
            if (el instanceof ObjectWrapper) {
                ObjectWrapper jsonObjectElement = (ObjectWrapper)el;
                childNodeElement = new JsonTreeNode("item" + i, el, JsonTreeNodeType.JSONObjectElement, jsonObjectElement.size());
                this.convertToTreeNode(jsonObjectElement, childNodeElement);
                childNode.add(childNodeElement);
                continue;
            }
            if (el instanceof ArrayWrapper) {
                ArrayWrapper jsonArrayElement = (ArrayWrapper)el;
                childNodeElement = new JsonTreeNode("item" + i, el, JsonTreeNodeType.JSONArrayElement, jsonArrayElement.size());
                this.convertToTreeNode(jsonArrayElement, childNodeElement);
                childNode.add(childNodeElement);
                continue;
            }
            Object obj = el;
            if (el instanceof String) {
                String str = (String)el;
                obj = "\"" + str + "\"";
            }
            childNode.add(new JsonTreeNode(obj).setValue(el).setNodeType(JsonTreeNodeType.JSONArrayElement));
        }
    }

    private JPopupMenu buildRightMousePopupMenu() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.addSeparator();
        group.add((AnAction)new CopyKeyAction(this.tree));
        group.addSeparator();
        group.add((AnAction)new CopyValueAction(this.tree));
        group.addSeparator();
        group.add((AnAction)new CopyKeyValueAction(this.tree));
        group.addSeparator();
        group.add((AnAction)new CopyNodePathAction(this.tree));
        group.addSeparator();
        group.add((AnAction)new ExpandMultiAction(this.tree));
        group.addSeparator();
        group.add((AnAction)new CollapseMultiAction(this.tree));
        group.addSeparator();
        group.add((AnAction)new JumpAction(this.tree));
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("popup", (ActionGroup)group);
        return actionPopupMenu.getComponent();
    }

    public Tree getTree() {
        return this.tree;
    }

    public JPanel getTreeComponent() {
        return this.treeComponent;
    }

    private static class StyleTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private VirtualFile file;

        private StyleTreeCellRenderer() {
        }

        public void setFile(VirtualFile file) {
            this.file = file;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object o;
            if (tree == null) {
                StyleTreeCellRenderer.$$$reportNull$$$0(0);
            }
            List<ConfigEntry> configEntries = YamlParser.parseYaml(this.file.getPath());
            JsonTreeNode jsonTreeNode = (JsonTreeNode)value;
            JsonTreeNodeType nodeType = jsonTreeNode.getNodeType();
            String text = jsonTreeNode.getUserObject().toString();
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            SimpleTextAttributes lightAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)simpleTextAttributes, (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES);
            SimpleTextAttributes blueAttributes = new SimpleTextAttributes(0, (Color)new JBColor(new Color(63, 120, 230), new Color(137, 174, 246)));
            SimpleTextAttributes purpleAttributes = new SimpleTextAttributes(0, (Color)new JBColor(new Color(248, 108, 101), new Color(244, 184, 181)));
            SimpleTextAttributes stringColorAttributes = new SimpleTextAttributes(0, (Color)new JBColor(new Color(6, 125, 23), new Color(104, 169, 114)));
            SimpleTextAttributes booleanWithNullColorAttributes = new SimpleTextAttributes(0, (Color)new JBColor(new Color(0, 51, 179), new Color(206, 141, 108)));
            SimpleTextAttributes numberColorAttributes = new SimpleTextAttributes(0, (Color)new JBColor(new Color(25, 80, 234), new Color(41, 171, 183)));
            Icon icon = PluginIcons.JSON_KEY;
            Integer size = jsonTreeNode.getSize();
            Object nodeValue = jsonTreeNode.getValue();
            String squareBracketsStart = "";
            String nodeTypeStr = "";
            String squareBracketsEnd = "";
            String sizeStrPre = "";
            Object sizeStr = "";
            Object sizeStrPost = "";
            String jsonValue = "";
            String jsonValueType = "";
            String string = jsonTreeNode.toString();
            YamlPersistent instance = YamlPersistent.getInstance();
            String yamlFilePath = instance.getYamlFilePath();
            if (StrUtil.isNotBlank((CharSequence)yamlFilePath)) {
                JSONObject object = JsonUtil.toObject(YamlUtil.getConfigJson(yamlFilePath), JSONObject.class);
                instance.setJsonObject(object);
            }
            JSONObject jsonObject = instance.getJsonObject();
            Object s = "";
            if (jsonObject != null && (o = jsonObject.get((Object)string.toLowerCase())) != null) {
                s = "" + o;
            }
            if (Objects.nonNull((Object)nodeType)) {
                switch (nodeType) {
                    case JSONObject: {
                        squareBracketsStart = " [";
                        nodeTypeStr = "object";
                        squareBracketsEnd = "]";
                        sizeStrPre = " (";
                        sizeStr = size + " " + YamlHelperBoundle.messageOnSystem("YamlHelper.Property", new Object[0]);
                        sizeStrPost = StrUtil.isEmpty((CharSequence)s) ? ")" : ") [" + (String)s + "]";
                        icon = PluginIcons.JSON_OBJECT;
                        break;
                    }
                    case JSONArray: {
                        squareBracketsStart = " [";
                        nodeTypeStr = "array";
                        squareBracketsEnd = "]";
                        sizeStrPre = " (";
                        sizeStr = size + " " + YamlHelperBoundle.messageOnSystem("YamlHelper.Element", new Object[0]);
                        sizeStrPost = StrUtil.isEmpty((CharSequence)s) ? ")" : ") [" + (String)s + "]";
                        icon = PluginIcons.JSON_ARRAY;
                        break;
                    }
                    case JSONObjectElement: {
                        squareBracketsStart = " [";
                        nodeTypeStr = "array_object";
                        squareBracketsEnd = "]";
                        sizeStrPre = " (";
                        sizeStr = size + " " + YamlHelperBoundle.messageOnSystem("YamlHelper.Property", new Object[0]);
                        sizeStrPost = StrUtil.isEmpty((CharSequence)s) ? ")" : ") [" + (String)s + "]";
                        icon = PluginIcons.JSON_OBJECT_ITEM;
                        break;
                    }
                    case JSONArrayElement: {
                        Object valueStr;
                        icon = PluginIcons.JSON_ITEM;
                        if (Objects.isNull(nodeValue)) {
                            valueStr = "null";
                            jsonValueType = "null";
                        } else if (nodeValue instanceof String) {
                            String str = (String)nodeValue;
                            if (str.isEmpty()) {
                                valueStr = "\"\"";
                            } else {
                                for (ConfigEntry configEntry : configEntries) {
                                    if (!str.contains(configEntry.get$Key())) continue;
                                    str = str.replace(configEntry.get$Key(), configEntry.getValue().toString());
                                }
                                valueStr = "\"" + str + "\"";
                            }
                            jsonValueType = String.class.getName();
                        } else if (nodeValue instanceof Boolean) {
                            jsonValueType = Boolean.class.getName();
                            valueStr = "" + nodeValue;
                        } else if (nodeValue instanceof Number) {
                            jsonValueType = Number.class.getName();
                            valueStr = "" + nodeValue;
                        } else {
                            valueStr = "" + nodeValue;
                        }
                        jsonValue = valueStr;
                        break;
                    }
                    case JSONObjectProperty: {
                        Object o2;
                        Object valueStr;
                        if (Objects.isNull(nodeValue)) {
                            valueStr = "null";
                            jsonValueType = "null";
                        } else if (nodeValue instanceof String) {
                            String str = (String)nodeValue;
                            if (str.isEmpty()) {
                                valueStr = "\"\"";
                            } else {
                                for (ConfigEntry configEntry : configEntries) {
                                    if (!str.contains(configEntry.get$Key())) continue;
                                    str = str.replace(configEntry.get$Key(), configEntry.getValue().toString());
                                }
                                valueStr = "\"" + str + "\"";
                            }
                            jsonValueType = String.class.getName();
                        } else if (nodeValue instanceof Boolean) {
                            jsonValueType = Boolean.class.getName();
                            valueStr = "" + nodeValue;
                        } else if (nodeValue instanceof Number) {
                            jsonValueType = Number.class.getName();
                            valueStr = "" + nodeValue;
                        } else {
                            valueStr = "" + nodeValue;
                        }
                        jsonValue = valueStr;
                        String trim = string.split(":")[0].trim();
                        if (jsonObject == null || (o2 = jsonObject.get((Object)trim.toLowerCase())) == null) break;
                        sizeStrPost = "[" + o2 + "]";
                        break;
                    }
                }
            }
            if (!Objects.equals((Object)JsonTreeNodeType.JSONArrayElement, (Object)nodeType)) {
                this.append((String)(Objects.equals((Object)JsonTreeNodeType.JSONObjectProperty, (Object)nodeType) ? text + ": " : text), simpleTextAttributes);
            }
            if (StrUtil.isNotBlank((CharSequence)squareBracketsStart)) {
                this.append(squareBracketsStart, lightAttributes, false);
            }
            if (StrUtil.isNotBlank((CharSequence)nodeTypeStr)) {
                this.append(nodeTypeStr, blueAttributes, false);
            }
            if (StrUtil.isNotBlank((CharSequence)squareBracketsEnd)) {
                this.append(squareBracketsEnd, lightAttributes, false);
            }
            if (StrUtil.isNotBlank((CharSequence)sizeStrPre)) {
                this.append(sizeStrPre, lightAttributes, false);
            }
            if (StrUtil.isNotBlank((CharSequence)sizeStr)) {
                this.append((String)sizeStr, purpleAttributes, false);
            }
            if (StrUtil.isNotBlank((CharSequence)sizeStrPost)) {
                this.append((String)sizeStrPost, lightAttributes, false);
            }
            if (StrUtil.isNotBlank((CharSequence)jsonValue)) {
                SimpleTextAttributes attributes = "null".equals(jsonValueType) || Boolean.class.getName().equals(jsonValueType) ? booleanWithNullColorAttributes : (String.class.getName().equals(jsonValueType) ? stringColorAttributes : (Number.class.getName().equals(jsonValueType) ? numberColorAttributes : stringColorAttributes));
                this.append(jsonValue, attributes, Objects.equals((Object)JsonTreeNodeType.JSONArrayElement, (Object)nodeType));
            }
            this.setIcon(icon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/wd/yamlhelper/wapper/JsonStructureComponentProvider$StyleTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

