/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.services.NotificationService;

public class JiraService
extends NotificationService {
    public static final String URL_PROP = "url";
    public static final String API_URL_PROP = "api_url";
    public static final String PROJECT_KEY_PROP = "project_key";
    public static final String USERNAME_PROP = "username";
    public static final String JIRA_ISSUE_TRANSITION_ID_PROP = "jira_issue_transition_id";
    public static final String COMMIT_EVENTS_PROP = "commit_events";
    private CharSequence password;

    @Override
    public GitLabApiForm servicePropertiesForm() {
        GitLabApiForm formData = new GitLabApiForm().withParam("merge_requests_events", this.getMergeRequestsEvents()).withParam(COMMIT_EVENTS_PROP, this.getCommitEvents()).withParam(URL_PROP, this.getUrl(), true).withParam(API_URL_PROP, this.getApiUrl()).withParam(PROJECT_KEY_PROP, this.getProjectKey()).withParam(USERNAME_PROP, this.getUsername(), true).withParam("password", this.getPassword(), true).withParam(JIRA_ISSUE_TRANSITION_ID_PROP, this.getJiraIssueTransitionId());
        return formData;
    }

    @Override
    @JsonIgnore
    public Boolean getCommitEvents() {
        return this.getProperty(COMMIT_EVENTS_PROP, null);
    }

    @Override
    public void setCommitEvents(Boolean commitEvents) {
        this.setProperty(COMMIT_EVENTS_PROP, commitEvents);
    }

    public JiraService withCommitEvents(Boolean commitEvents) {
        this.setCommitEvents(commitEvents);
        return this;
    }

    public JiraService withMergeRequestsEvents(Boolean mergeRequestsEvents) {
        return this.withMergeRequestsEvents(mergeRequestsEvents, this);
    }

    @JsonIgnore
    public CharSequence getPassword() {
        return this.password;
    }

    public void setPassword(CharSequence password) {
        this.password = password;
    }

    public JiraService withPassword(CharSequence password) {
        this.setPassword(password);
        return this;
    }

    @JsonIgnore
    public String getUrl() {
        return this.getProperty(URL_PROP);
    }

    public void setUrl(String url) {
        this.setProperty(URL_PROP, url);
    }

    public JiraService withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    @JsonIgnore
    public String getApiUrl() {
        return this.getProperty(API_URL_PROP);
    }

    public void setApiUrl(String apiUrl) {
        this.setProperty(API_URL_PROP, apiUrl);
    }

    public JiraService withApiUrl(String apiUrl) {
        this.setApiUrl(apiUrl);
        return this;
    }

    @JsonIgnore
    public String getProjectKey() {
        return this.getProperty(PROJECT_KEY_PROP);
    }

    public void setProjectKey(String projectKey) {
        this.setProperty(PROJECT_KEY_PROP, projectKey);
    }

    public JiraService withProjectKey(String projectKey) {
        this.setProjectKey(projectKey);
        return this;
    }

    @JsonIgnore
    public String getUsername() {
        return this.getProperty(USERNAME_PROP);
    }

    public void setUsername(String username) {
        this.setProperty(USERNAME_PROP, username);
    }

    public JiraService withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    @JsonIgnore
    public Integer getJiraIssueTransitionId() {
        return this.getProperty(JIRA_ISSUE_TRANSITION_ID_PROP, null);
    }

    public void setJiraIssueTransitionId(Integer jiraIssueTransitionId) {
        this.setProperty(JIRA_ISSUE_TRANSITION_ID_PROP, jiraIssueTransitionId);
    }

    public JiraService withJiraIssueTransitionId(Integer jiraIssueTransitionId) {
        this.setJiraIssueTransitionId(jiraIssueTransitionId);
        return this;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.fixJiraIssueTransitionId(properties);
        super.setProperties(properties);
    }

    private void fixJiraIssueTransitionId(Map<String, Object> properties) {
        Object jiraIssueTransitionId;
        if (properties != null && (jiraIssueTransitionId = properties.get(JIRA_ISSUE_TRANSITION_ID_PROP)) instanceof String) {
            if (((String)jiraIssueTransitionId).trim().isEmpty()) {
                properties.put(JIRA_ISSUE_TRANSITION_ID_PROP, null);
            } else {
                properties.put(JIRA_ISSUE_TRANSITION_ID_PROP, Integer.valueOf((String)jiraIssueTransitionId));
            }
        }
    }
}

